call spMante_Guia_Cab(1, 1, 128, 6, '2011-04-18', '2011-04-18', 2, '140101', 'Calle Educacin # 118 - Urb. San Luis', '140105', 'PSTO 11 - MOSHOQUEQUE', 319.06, 1);

DROP PROCEDURE IF EXISTS spMante_Guia_Cab;
CREATE PROCEDURE spMante_Guia_Cab(
  varVenta      int,
  varLocal      int,
  varCliente    int,
  varVendedor   int,
  varFechaEmi   date, 
  varFechaTra   date,
  varCondicion  int,
  varUbigeoPar  varchar(6),
  varDireccPar  varchar(80),
  varUbigeoDes  varchar(6),
  varDireccDes  varchar(80),
  varTotal      double,
  varUsuario    int
  )
BEGIN
  /* DISTRIBUCIONES MENFAR */
	DECLARE varNum      int;
  DECLARE varTipo     char(3);
  DECLARE varNumDoc   varchar(20);
  DECLARE varSubTotal, varIGV double;
  
  SET varTipo = 4;
  SET varNumDoc = spFuncion_NumeroDocumento(varTipo);  
	SELECT if(isnull(MAX(id_guia)),0,MAX(id_guia))+1 INTO varNum FROM _sv_guia;  
  
  SET varSubTotal = varTotal/1.19;
  SET varIGV = varTotal - varSubTotal;
  
  -- ANULAMOS GUIAS DE DICHA VENTA
  update _sv_guia 
  set estado='AN', _date_update = NOW(), _user_update = varUsuario 
  where id_venta = varVenta;
  
  -- REGISTRAMOS CABECERA DE LA GUIA
  insert into _sv_guia (id_guia, id_venta, id_local, id_cliente, id_vendedor, fecha_emision, fecha_traslado, id_condicion, 
                        id_tipo_doc, nro_documento, id_ubigeo_partida, direccion_partida, id_ubigeo_destino, direccion_destino, estado, 
                        subtotal, igv, total, _date_create, _date_update, _user_create, _user_update)
	              VALUES (varNum, varVenta, varLocal, varCliente, varVendedor, varFechaEmi, varFechaTra, varCondicion, 
                        varTipo, varNumDoc, varUbigeoPar, varDireccPar, varUbigeoDes, varDireccDes, 'AC',
                        varSubTotal, varIgv, varTotal, NOW(), NOW(), varUsuario, varUsuario);                     
  
  -- REGISTRAMOS DETALLE DE LA GUIA
  INSERT INTO _sv_guia_detalle(id_guia, id_producto, cantidad, precio, subtotal, igv, total, _date_create, _date_update, _user_create, _user_update)
  select varNum as id_guia, id_producto, cantidad, precio, subtotal, igv, total, NOW(), NOW(), varUsuario, varUsuario
  from _sv_venta_detalle
  where id_venta = varVenta;
  
  -- ACTUALIZAMOS NUMERO DE GUIA EN LA VENTA
  update _sv_venta
  set nro_guia = varNumDoc, _date_update = NOW(), _user_update = varUsuario
  where id_venta = varVenta;
  
  /*ACTUALIZAMOS EL CORRELATIVO DEL TIPO DE DOCUMENTO*/
  UPDATE _sv_forma_pago
  SET secuencia = secuencia + 1
  where id_tipo_doc = varTipo;
  
  SELECT varNum;
  
END;
