call spMante_Gasto('NEW', NULL, 'O', 'FLETE DE VEHICULO', 'FLETE', 1);
 
DROP PROCEDURE IF EXISTS spMante_Gasto;
CREATE PROCEDURE spMante_Gasto(
	varOpcion     varchar(10),
	varCodigo     int,
  varTipo       char(1),
	varNombre     varchar(80),
	varAbrev      varchar(20),
  varCosto      double,
  varEstado     char(1),
	varUsuario    int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
	if varOpcion='NEW' then    
    select count(*) INTO varExiste from _sv_gasto 
    where _estado = 'A' 
    and TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre));
    
    if varExiste <= 0 then 
      
      SELECT ifnull(max(id_gasto),0)+1 INTO varCodigo FROM _sv_gasto;    
      
      INSERT INTO _sv_gasto (id_gasto, id_tipo, nombre, abrev, monto, estado,
                             _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, varTipo, UPPER(varNombre), varAbrev, varCosto, varEstado,
              NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('EL GASTO ', varNombre, ' \nYA SE ENCUENTRA REGISTRADO');
    end if;    	
	else
    
    select count(*) INTO varExiste  from _sv_gasto
    where _estado = 'A'  and id_gasto <> varCodigo
    and TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre));
    
    if varExiste <= 0 then 
      update _sv_gasto set      
      nombre       = UPPER(varNombre),       
      abrev        = varAbrev, 
      id_tipo      = varTipo,
      monto        = varCosto,
      estado       = varEstado,
      _date_update = NOW(),
      _user_update = varUsuario
      where id_gasto = varCodigo;
    else
      set varError = CONCAT('EL GASTO ', varNombre, ' \nYA SE ENCUENTRA REGISTRADO');
    end if;		
	end if;
  SELECT varError;
END;