call spMante_Cambio_Det(88097, 1, 1, '010009',  12, 0, 'UND', '12012', '2013-12-30', 'C', 
													'2014-01-02', 1);

DROP PROCEDURE IF EXISTS spMante_Cambio_Det;
CREATE PROCEDURE spMante_Cambio_Det(
  varNumVenta   int, 
  varEmpresa    int,
  varAlmacen    int,
	varProducto   varchar(6),   
	varCantidad   double,
  varPrecio     double,
  varUnidMed    varchar(10),
  varLote       varchar(15),
  varFechaVen   date,
  varTipoDet    char(1),
  varFecha      date,  
  varUsuario    int
  )
BEGIN  
  DECLARE varTotal, varSubTotal, varIgv, varFactor, varCantStock double;  
  DECLARE varUMStock, varOpera varchar(10);
  DECLARE varCantReal  double;
  DECLARE varExiste int;
  DECLARE varAlmAveria int;
  
  SET varUMStock    = (select id_um_stock from _sv_producto where id_producto = varProducto);
  
  SET varCantReal  = (select  case when F.operacion = '*' then (case when K.cantidad>0 then K.cantidad else 0 end)*F.factor 
                                   when F.operacion = '/' then (case when K.cantidad>0 then K.cantidad else 0 end)/F.factor 
                              end as STOCK
                      from _sv_kardex K
                      inner join _sv_producto P ON K.id_producto = P.id_producto
                      inner join _sv_factor_conv F ON P.id_um_stock = F.id_um_origen and P.id_um_venta = F.id_um_destino
                      where K._estado   = 'A'
               