CALL spMante_Cambio_Anular(2,88111,1);

DROP PROCEDURE IF EXISTS spMante_Cambio_Anular;
CREATE PROCEDURE spMante_Cambio_Anular(
  varEmpresa    int,
	varNumVenta   bigint,
  varUsuario    int
  )
BEGIN 
  DECLARE varExiste, varAlmacen, varAverias int;
  DECLARE varCantidad   double;
  DECLARE varProducto   varchar(6);
  DECLARE varMovimiento varchar(5);
  DECLARE varReturn text default '';
  
  DECLARE done INT DEFAULT 0;
  DECLARE curDetDoc CURSOR FOR 
		      select D.id_producto, D.cantidad, D.id_movimiento, V.id_almacen, A.id_averias
          from _sv_venta_detalle D
          inner join _sv_venta V ON  D.id_venta = V.id_venta
          inner join _sv_almacen A ON V.id_almacen = A.id_almacen
          where V.id_empresa  = varEmpresa
          and D.id_venta      = varNumVenta;
  
	DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;
  
  /*Verificamos si es un documento de cambios*/
  select count(id_venta) into varExiste
  from _sv_venta V
  inner join _sv_tipo_doc_venta T ON T.id_tipo_doc = V.id_tipo_doc
  where T.flag_cambio <> 'S'
  and V.id_venta = varNumVenta;
  if varExiste > 0 then
    set varReturn = "=> EL TIPO DE DOCUMENTO NO ES CAMBIO\n";
    set varExiste = 0;
  end if;
  
  /*Verificamos si el documento ya esta anulado*/
  select count(id_venta) into varExiste
  from _sv_venta
  where id_venta = varNumventa
  and estado = 'AN';
  if varExiste > 0 then
    set varReturn = CONCAT(varReturn,"=> EL DOCUMENTO YA ESTA ANULADO\n");
    set varExiste = 0;
  end if;
  
  /*Verificamos si existe almacen de averias*/
  select count(id_venta) into varExiste 
  from _sv_venta  V
  inner join _sv_almacen A on V.id_almacen = A.id_almacen
  where V.id_venta= varNumVenta 
  and A.id_averias is null;
  if varExiste > 0 then
    set varReturn = CONCAT(varReturn,"=> NO EXISTE ALMACEN DE AVERIAS CONFIGURADO\n");
    set varExiste = 0;
  end if;
  
  if varReturn = "" then
    set varReturn = "OK";
    /*Cambiamos a Estado ANULADO=AN el Documento Seleccionado*/
    update _sv_venta 
    set estado    = 'AN', 
    subtotal      = 0, 
    igv           = 0, 
    total         = 0, 
    saldo         = 0,  
    _date_update  = NOW(), 
    _user_update  = varUsuario 
    where id_venta= varNumVenta
    and id_empresa= varEmpresa;    
   
    /* Recorremos los Articulos que contiene el Documento a Anular */
    OPEN curDetDoc;
    REPEAT
      FETCH curDetDoc INTO varProducto, varCantidad, varMovimiento, varAlmacen, varAverias;
      IF NOT done THEN
        -- Almacen Fisico
        update _sv_kardex 
        SET cantidad      = cantidad + varCantidad,
        _date_update      = NOW(),
        _user_update      = varUsuario
        where id_empresa  = varEmpresa
        and id_almacen    = varAlmacen
        and id_producto   = varProducto;
  