call spMante_Almacen('EDIT', 1, NULL, NULL, NULL, 'ALM NSC PRINCIAL', 'NSC_PRIN', 'EUFEMIO LORA Y LORA 1215', '140101', 1);
call spMante_Almacen('NEW', NULL, 2, 2, 1, 'ALM AIC PRINCIPAL', 'AIC_PRIN', 'EUFEMIO LORA Y LORA 1215', '140101', 1);

DROP PROCEDURE IF EXISTS spMante_Almacen;
CREATE PROCEDURE spMante_Almacen(
	varOpcion   varchar(10),
	varCodigo   int,
	varEmpresa  int,
  varAgencia  int,
  varTipo     int,
  varNombre   varchar(100),
  varAbrev    varchar(20),
  varDirecc   varchar(100),
  varUbigeo   varchar(6),
  varAverias  int,
	varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	if varOpcion='NEW' then
    -- Validamos que el nombre del almacen no exista
    select count(*) INTO varExiste  from _sv_almacen 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))  and _estado = 'A'
    and id_empresa = varEmpresa;
    if varExiste > 0 then
      set varError = CONCAT('EL ALMACEN <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADO PARA ESTA EMPRESA\n');
    end if;
    
    if varError = '' then 
      SELECT ifnull(max(id_almacen),0)+1 INTO varCodigo FROM _sv_almacen;
      INSERT INTO _sv_almacen (id_almacen, id_empresa, id_agencia, id_tipo_almacen, nombre, abrev, direccion, id_ubigeo, id_averias, 
                               _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, varEmpresa, varAgencia, varTipo, UPPER(varNombre), UPPER(varAbrev), UPPER(varDirecc), varUbigeo, varAverias,
              NOW(),NOW(), varUsuario, varUsuario);
      set varError = 'OK';
    end if;
	else
    -- Validamos que el razon social de la empresa no exista
    select count(*) INTO varExiste  from _sv_almacen 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) and _estado = 'A' 
    and id_almacen <> varCodigo and id_empresa = (select id_empresa from _sv_almacen where id_almacen=varCodigo);
    if varExiste > 0 then
      set varError = CONCAT('EL ALMACEN <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADA EN ESTA EMPRESA\n');
    end if;
    
    if varError = '' then 
      update _sv_almacen set
      nombre      = UPPER(varNombre),
      abrev       = UPPER(varAbrev),
      direccion   = UPPER(varDirecc),
      id_ubigeo   = varUbigeo,
      id_averias  = varAverias,
      _date_update = NOW(),
      _user_update = varUsuario
      where id_almacen = varCodigo;
      set varError = 'OK';
    end if;
	end if;
  select varError;
END;