<?php
include_once '../conexion.php';

// Obtener los datos combinados del cuerpo de la solicitud
$data = json_decode( file_get_contents( 'php://input' ), true );

// Iniciar la transacción
mysqli_autocommit( $conn, false );
// Variable para verificar el estado de la transacción
$transaccionExitosa = true;
$errorMensaje = '';

try {
    // Acceder a los valores individuales de los datos combinados
    $cNRecibo = $data[ 'NRecibo' ];
    $cFecha = $data[ 'Fecha' ];
    $cImporte = $data[ 'Deuda' ];
    $cNombre = $data[ 'Nombre' ];
    $cMoneda = $data[ 'Moneda' ];
    $cTipoCambio = $data[ 'Tipo_Cambio' ];
    $cBanco = $data[ 'Banco' ];
    $cCtaCte = $data[ 'CtaBco' ];
    $cLugar = $data[ 'Lugar_Pago' ];
    $cOperacion = $data[ 'NOperacion' ];
    $cProveedor_Id = $data[ 'Proveedor_Id' ];
    $cCaja_Id = $data[ 'Caja_Id' ];
    $cNomCaja = $data[ 'NomCaja' ];
    $cSucursal_Id = $data[ 'Sucursal_Id' ];
    $cEmpresa_Id = $data[ 'Empresa_Id' ];
    $iIdCob = $data[ 'nIdCob_Mod' ];
    $cEstado = $data[ 'Estado' ];

    if ( $cEstado == 'NUEVO' ) {

        // Ejemplo de inserción en la tabla Pagos
        $queryCabecera = "INSERT INTO pagos(nrecibo, fecha, importe, razon_social, moneda, tipo_cambio, banco, cuenta_corriente, lugar, operacion,
          proveedor_id, caja_id, sucursal_id, empresa_id)
        VALUES('$cNRecibo', '$cFecha', '$cImporte', '$cNombre', '$cMoneda', '$cTipoCambio', '$cBanco', '$cCtaCte', '$cLugar', '$cOperacion',
          '$cProveedor_Id', '$cCaja_Id', '$cSucursal_Id', '$cEmpresa_Id')";

        $resultadoCabecera = mysqli_query( $conn, $queryCabecera );
        if ( !$resultadoCabecera ) {
            throw new Exception( mysqli_error( $conn ) );
        }

        // Obtener el ID del último registro insertado en la cabecera de Pagos
        $idCobranza = mysqli_insert_id( $conn );

        // ACTUALIZA REGISTRO DE SERIES
        $query = "SELECT numero FROM series_sucursal WHERE empresa_id = $cEmpresa_Id AND sucursal_id = $cSucursal_Id 
           AND nserie = Left('$cNRecibo',4) FOR UPDATE";
        $result = mysqli_query( $conn, $query );
        if ( !$result ) {
            throw new Exception( mysqli_error( $conn ) );
        }

        $queryUPD = "UPDATE series_sucursal SET numero = numero + 1 WHERE empresa_id = $cEmpresa_Id AND sucursal_id = $cSucursal_Id 
          AND nserie = Left('$cNRecibo',4)";
        $resultUPD = mysqli_query( $conn, $queryUPD );

        if ( !$resultUPD ) {
            throw new Exception( mysqli_error( $conn ) );
        }

        // CAJA
        $queryCaja = "INSERT INTO detcaja(cuenta_id, nombre, tipo_movcaja, nrecibo, fecha_operacion, egreso, partida_id, nombre_partida, 
              moneda, tipo_cambio, fecha_emision, movimiento_id, operacion, offsystem, empresa_id, sucursal_id)
          VALUES('$cCaja_Id', '$cNomCaja', 'E', '$cNRecibo', '$cFecha', '$cImporte', '$cProveedor_Id', '$cNombre',
                 '$cMoneda', '$cTipoCambio', '$cFecha', '$idCobranza', 'PAG', '1', '$cEmpresa_Id', '$cSucursal_Id')";

        $resultadoCaja = mysqli_query( $conn, $queryCaja );
        if ( !$resultadoCaja ) {
            throw new Exception( mysqli_error( $conn ) );
        }

        // Ejemplo de inserción en la tabla detalle
        foreach ( $data[ 'detalle' ] as $detalle_ ) {
            $cNSerie = $detalle_[ 'nserie' ];
            $cNDocumento = $detalle_[ 'ndocumento' ];
            $cNLetra = $detalle_[ 'nro_letra' ];
            $cNUnico = $detalle_[ 'nro_unico' ];
            $cImporte_ = $detalle_[ 'importe' ];
            $cDeuda = $detalle_[ 'deuda' ];
            $cFecha_Emi = $detalle_[ 'fecha_documento' ];
            $cFecha_Venc = $detalle_[ 'fecha_vencimiento' ];
            $cSaldo = $detalle_[ 'saldo' ];
            $idcompra = $detalle_[ 'compra_id' ];
            $bElegir = $detalle_['elegir'];

            $queryDetalle = "INSERT INTO detpagos(nrecibo, fecha, nserie, ndocumento, nro_letra, nro_unico, importe, moneda, tipo_cambio, deuda, fecha_documento, 
                fecha_vencimiento, saldo, elegir, pago_id, proveedor_id, compra_id, sucursal_id, empresa_id)
            VALUES('$cNRecibo', '$cFecha', '$cNSerie', '$cNDocumento', '$cNLetra', '$cNUnico', '$cImporte_', '$cMoneda', '$cTipoCambio', '$cDeuda', '$cFecha_Emi',
                '$cFecha_Venc', '$cSaldo', '$bElegir', '$idCobranza', '$cProveedor_Id', '$idcompra', '$cSucursal_Id', '$cEmpresa_Id')";

            $resultadoDetalle = mysqli_query( $conn, $queryDetalle );
            if ( !$resultadoDetalle ) {
                throw new Exception( mysqli_error( $conn ) );
            }
        }

    } elseif ( $cEstado == 'MODIFICAR' ) {

        $queryUpd_DetCob = "UPDATE detpagos SET IUD = 'D' WHERE pago_id = $iIdCob";
        $resultadoUpd_DetCob = mysqli_query( $conn, $queryUpd_DetCob );

        if ( !$resultadoUpd_DetCob ) {
            throw new Exception( mysqli_error( $conn ) );
        }

        // Ejemplo de inserción en la tabla Pagos
        $queryCabecera = "UPDATE pagos SET nrecibo = '$cNRecibo', fecha = '$cFecha', importe = '$cImporte', razon_social = '$cNombre', 
        moneda = '$cMoneda', tipo_cambio = '$TipoCambio', banco = '$cBanco', cuenta_corriente = '$cCtaCte', lugar = '$cLugar', operacion = '$cOperacion',
        proveedor_id = '$cProveedor_Id', caja_id = '$cCaja_Id' WHERE id = $iIdCob";

        $resultadoCabecera = mysqli_query( $conn, $queryCabecera );
        if ( !$resultadoCabecera ) {
            throw new Exception( mysqli_error( $conn ) );
        }

        // CAJA
        $queryCaja = "UPDATE detcaja SET cuenta_id = cCaja_Id, nrecibo = '$cNRecibo', fecha_operacion = '$cFecha', egreso = '$cImporte',
           partida_id = '$cProveedor_Id', nombre_partida = '$cNombre', moneda = '$cMoneda', tipo_cambio = '$cTipoCambio'
        WHERE movimiento_id = $iIdCob AND operacion = 'PAG'";

        $resultadoCaja = mysqli_query( $conn, $queryCaja );
        if ( !$resultadoCaja ) {
            throw new Exception( mysqli_error( $conn ) );
        }

        // Ejemplo de inserción en la tabla detalle
        foreach ( $data[ 'detalle' ] as $detalle_ ) {
            $cNSerie = $detalle_[ 'nserie' ];
            $cNDocumento = $detalle_[ 'ndocumento' ];
            $cNLetra = $detalle_[ 'nro_letra' ];
            $cNUnico = $detalle_[ 'nro_unico' ];
            $cImporte_ = $detalle_[ 'importe' ];
            $cDeuda = $detalle_[ 'deuda' ];
            $cFecha_Emi = $detalle_[ 'fecha_documento' ];
            $cFecha_Venc = $detalle_[ 'fecha_vencimiento' ];
            $cSaldo = $detalle_[ 'saldo' ];
            $idcompra = $detalle_[ 'compra_id' ];
            $bElegir = $detalle_['elegir'];

            $queryDetalle = "INSERT INTO detpagos(nrecibo, fecha, nserie, ndocumento, nro_letra, nro_unico, importe, moneda, tipo_cambio, deuda, fecha_documento, 
                fecha_vencimiento, saldo, elegir, pago_id, proveedor_id, compra_id, sucursal_id, empresa_id)
            VALUES('$cNRecibo', '$cFecha', '$cNSerie', '$cNDocumento', '$cNLetra', '$cNUnico', '$cImporte_', '$cMoneda', '$cTipoCambio', '$cDeuda', '$cFecha_Emi',
                '$cFecha_Venc', '$cSaldo', '$bElegir', '$idCobranza', '$cProveedor_Id', '$idcompra', '$cSucursal_Id', '$cEmpresa_Id')";

            $resultadoDetalle = mysqli_query( $conn, $queryDetalle );
            if ( !$resultadoDetalle ) {
                throw new Exception( mysqli_error( $conn ) );
            }
        }

        //Elimina Detalle de Pagos para Evitar la Duplicidad
        $queryDelCob = "DELETE FROM detpagos WHERE pago_id = $iIdCob AND IUD = 'D'";
        $resultadoDelCob = mysqli_query( $conn, $queryDelCob );

        if ( !$resultadoDelCob ) {
            throw new Exception( mysqli_error( $conn ) );
        }

    }

    // Confirmar la transacción
    mysqli_commit( $conn );

} catch ( Exception $e ) {
    // Revertir la transacción en caso de error
    mysqli_rollback( $conn );
    $transaccionExitosa = false;
    $errorMensaje = $e->getMessage();
}

// Cerrar la conexión a la base de datos
mysqli_close( $conn );

// Enviar una respuesta al cliente
if ( $transaccionExitosa ) {
    $response = array();
    //$response = array( 'ESTADO' => '00', 'MENSAJE' => 'Los datos se han guardado correctamente' );
    if ( $cEstado == 'NUEVO' ) {
        if ( $idCobranza > 0 ) {
            //$response = array();
            $response[ 'ESTADO' ] = '00';
            $response[ 'ID' ] = $idCobranza;
            $response[ 'MENSAJE' ] = 'Los datos se han guardado correctamente';
        } else {
            //$response = array();
            $response[ 'ESTADO' ] = '11';
            $response[ 'ID' ] = 0;
            $response[ 'MENSAJE' ] = 'Error al guardar la información: ' . $errorMensaje;
        }
    } else {
        //$response = array();
        $response[ 'ESTADO' ] = '00';
        $response[ 'ID' ] = $iIdCob;
        $response[ 'MENSAJE' ] = 'Los datos se actualizaron correctamente';
    }
} else {
    //$response = array( 'ESTADO' => '11', 'MENSAJE' => 'Error al guardar la información: ' . $errorMensaje );
    $response = array();
    $response[ 'ESTADO' ] = '111';
    $response[ 'ID' ] = 0;
    $response[ 'MENSAJE' ] = 'Error al guardar la información: ' . $errorMensaje;
}
echo json_encode( $response );

?>