<?php

error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

include_once '../conexion.php';

$bodyRequest = file_get_contents("php://input");

// Decodifica el cuerpo de la solicitud y lo guarda en un array de PHP
$data = json_decode($bodyRequest, true);

// Iniciar la transacción
mysqli_autocommit($conn, false);
// Variable para verificar el estado de la transacción
$transaccionExitosa = true;
$errorMensaje = "";

try {
    $cEmpresa_Id = $data['Empresa_id'];
    $cDocFiscal_id = $data['DocFiscal_Id'];
    $cNSerie = $data['NSerie'];
    $cNDocumento = $data['NDocumento'];
    $cFechaEmision = $data['Fecha_Emision'];
    $cFechaTraslado = $data['Fecha_Traslado'];
    $cFechaVencimiento = $data['Fecha_Vcto'];
    $cNombre = $data['Razon_Social'];
    $cDireccion = $data['Direccion'];
    $cTipDocIdent = $data['Tipo_Documento'];
    $cDocIdentidad = $data['DocIdentidad'];
    $cNDias = $data['NDias'];
    $cMoneda = $data['Moneda'];
    $cTipoCambio = $data['Tipo_Cambio'];
    $cAfectoIgv = $data['Afecto_IGV'];
    $cP_Igv = $data['pIGV'];
    $cIgv = $data['IGV'];
    $cAfectDscto = $data['Descuento'];
    $cP_Dscto = $data['pDSCTO'];
    $cDescuento = $data['Descuento'];
    $cAfectoPercepcion = $data['Afecto_Percepcion'];
    $cP_Percepcion = $data['pPercepcion'];
    $cPercepcion = $data['Percepcion'];
    $cAfecto = $data['Valor_Venta'];
    $cInafecto = $data['Inafecto'];
    $cExonerado = $data['Exonerada'];
    $cTotal = $data['Total_Pagar'];
    $cGuiaRemision = $data['NGuiaRemision'];
    $cCancelado = $data['Cancelado'];
    $cIcbp = $data['ICBPER'];
    $cGratuitas = $data['Gratuitas'];
    $cAfectaKardex = $data['Afecta_Kardex'];
    $cAfectaCaja = $data['Afecta_Caja'];
    $cPeriodo = $data['Periodo'];
    $cMes = $data['Mes'];
    $cFormaPago_Id = $data['Forma_Pago'];
    $cCaja_Id = $data['Caja_Id'];
    $cCliente_Id = $data['Cliente_Id'];
    $cEmpleado_id = $data['Empleado_Id'];
    $cSucursal_Id = $data['Sucursal_Id'];
    $cObservacion = $data['Observacion'];
    $cAcuenta = $data['a_Cuenta'];
    $cServicio = $data['Servicio'];
    $cZona_Id = $data['Zona_Id'];
    $iIdVta = $data['IdVta_M'];
    $cEstado = $data['Estado'];

    // Ejemplo de inserción en la tabla detalle
    $insertDetalle = "INSERT INTO detventas (venta_id, nserie, ndocumento, fecha_emision, fecha_traslado, almacen_id, producto_id, bonificacion, codigo_producto, cantidad, recogido, capacidad_precio, descrip_precio, precio_bruto, descuento, precio, precioigv, igv, percepcion, afecto, inafecto, exonerado, subtotal, subtotaligv, margen, costo, peso, porcentaje_igv, icbp, descripcion_servicio, vencimiento, lote, abrev_universal, docfiscal_id, categoria_id, marca_id, modelo_id, empresa_id, sucursal_id) 
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    $stmtDetalle = mysqli_prepare($conn, $insertDetalle);
    if (!$stmtDetalle) {
        throw new Exception(mysqli_error($conn));
    }

    foreach ($data['detalle'] as $detalle_) {
       //$cVenta_Id = $idVenta;
       $cNSerie = $detalle_['Nserie'];
       $cNDocumento = $detalle_['Ndocumento'];
       //$cFechaEmision = $detalle_['Fecha_emision'];
       //$cFechaTraslado = $detalle_['Fecha_traslado'];
       $cOperacion = 'VTA';
       $cAlmacen_Id =3;
       $cProducto_Id = $detalle_['Producto_id'];
       $cBonificdProd = $detalle_['Bonificaion'];
       $cCodProd = $detalle_['Codigo_producto'];
       $cCantidad = $detalle_['Cantidad'];
       $cRecogido = $detalle_['Recogido'];
       $cCapacidad_Precio = $detalle_['Capacidad_precio'];
       $cDescrip_Precio = $detalle_['Descrip_precio'];
       $cPrecio_Bruto = $detalle_['Precio_bruto'];
       $cDescuento = $detalle_['Descuento'];
       $cPrecio = $detalle_['Precio'];
       $cPrecioigv = $detalle_['Precioigv'];
       $cIgv = $detalle_['Igv'];
       $cPercepcion = $detalle_['Percepcion'];
       $cAfecto = $detalle_['Afecto'];
       $cInafecto = $detalle_['Inafecto'];
       $cExonerado = $detalle_['Exonerado'];
       $cSubtotal = $detalle_['Subtotal'];
       $cSubtotaligv = $detalle_['Subtotaligv'];
       $cMargen = $detalle_['Margen'];
       $cCosto = $detalle_['Costo'];
       $cPeso = $detalle_['Peso'];
       $cPorcentaje_Igv = $detalle_['Porcentaje_igv'];
       $cIcbp = $detalle_['Icbp'];
       $cDescripcion_Servicio = $detalle_['Descripcion_servicio'];
       $cVencimiento = $detalle_['Vencimiento'];
       $cLote = $detalle_['Lote'];
       $cAbrev_Universal = $detalle_['Abrev_universal'];
       $cRazon_Social = $cNombre;
       $cObservacion = $cObservacion;
       $cIdDocFis = $cDocFiscal_id;
       $cCategoria_Id = $detalle_['Categoria_id'];
       $cMarca_Id = $detalle_['Marca_id'];
       $cModelo_Id = $detalle_['Modelo_id'];
       $cEmpresa_Id = $detalle_['Empresa_id'];
       $cSucursal_Id = $detalle_['Sucursal_id'];

        mysqli_stmt_bind_param($stmtDetalle, 'ssssiiisssssssssssssssssssssssssssssss', $iIdVta, $cNSerie, $cNDocumento, $cFechaEmision, $cFechaTraslado, $cAlmacen_Id, $cProducto_Id, $cBonificdProd, $cCodProd, $cCantidad, $cRecogido, $cCapacidad_Precio, $cDescrip_Precio, $cPrecio_Bruto, $cDescuento, $cPrecio, $cPrecioigv, $cIgv, $cPercepcion, $cAfecto, $cInafecto, $cExonerado, $cSubtotal, $cSubtotaligv, $cMargen, $cCosto, $cPeso, $cPorcentaje_Igv, $cIcbp, $cDescripcion_Servicio, $cVencimiento, $cLote, $cAbrev_Universal, $cIdDocFis, $cCategoria_Id, $cMarca_Id, $cModelo_Id, $cEmpresa_Id, $cSucursal_Id);

        $resultadoDetalle = mysqli_stmt_execute($stmtDetalle);
        if (!$resultadoDetalle) {
            throw new Exception(mysqli_error($conn));
        }

        //KARDEX
        if ($cAfectaKardex == 1) {
            $insertKardex = "INSERT INTO kardex(nserie, ndocumento, fecha_emision, fecha_traslado, operacion, producto_id, codigo_producto, entrada, costo, salida, precio_venta, recogido, vencimiento, lote, transito, razon_social, observacion, unidad_medida, empresa_id, sucursal_id, almacen_id, compra_id, venta_id, capacidad_Precio, docfiscal_id, categoria_id, marca_id, modelo_id)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

            $stmtKardex = mysqli_prepare($conn, $insertKardex);
            if (!$stmtKardex) {
                throw new Exception(mysqli_error($conn));
            }

            mysqli_stmt_bind_param($stmtKardex, 'ssssssssssssssssssssssssssssssssssss', $cNSerie, $cNDocumento, $cFechaEmision, $cFechaTraslado, $cOperacion, $cProducto_Id, $cCodProd, 0, $cCosto, ($cCantidad * $cCapacidad_Precio), $cPrecioigv, ($cRecogido * $cCapacidad_Precio) * -1, $cVencimiento, $cLote, 0, $cNombre, $cObservacion, $cDescrip_Precio, $cEmpresa_Id, $cSucursal_Id, $cAlmacen_Id, 0, $iIdVta, $cCapacidad_Precio, $cIdDocFis, $cCategoria_Id, $cMarca_Id, $cModelo_Id);

            $resultadoKardex = mysqli_stmt_execute($stmtKardex);
            if (!$resultadoKardex) {
                throw new Exception(mysqli_error($conn));
            }
        }
    }

    // Confirmar la transacción
    mysqli_commit($conn);
} catch (Exception $e) {
    // Revertir la transacción en caso de error
    mysqli_rollback($conn);
    $transaccionExitosa = false;
    $errorMensaje = $e->getMessage();
}

// Cerrar las declaraciones preparadas
if (isset($stmtDetalle)) {
    mysqli_stmt_close($stmtDetalle);
}

if (isset($stmtKardex)) {
    mysqli_stmt_close($stmtKardex);
}

// Cerrar la conexión a la base de datos
mysqli_close($conn);

// Enviar una respuesta al cliente
if ($transaccionExitosa) {
    $response = array("ESTADO" => "00", "MENSAJE" => "Los datos se han guardado correctamente");
} else {
    $response = array("ESTADO" => "11", "MENSAJE" => "Error al guardar la información: " . $errorMensaje);
}
echo json_encode($response);
?>
