<?php
    error_reporting(E_ALL ^ E_NOTICE);

    // Permite solicitudes desde cualquier origen (cuidado con esto en producción)
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
    header("Access-Control-Allow-Headers: Content-Type");

    include_once '../conexion.php';

    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    $sql = $conn->prepare("CALL UP_Venta(?,?,?,?,?,?)");
    $sql->bind_Param("sssssi", $datos[0], $datos[1], $datos[2], $datos[3], $datos[4], $datos[5]);

    $sql->execute();

    // Verificar si la actualización fue exitosa
    if ($sql->affected_rows > 0) {
        $response = [
            'status' => 'success',
            'message' => 'Actualización exitosa.'
        ];
    } else {
        $response = [
            'status' => 'error',
            'message' => 'No se pudo actualizar el registro.'
        ];
    }

    // Cerrar la conexión a la base de datos
    $sql->close();
    $conn->close();

    // Devolver la respuesta como un objeto JSON
    header("Content-type: application/json; charset=utf-8");
    echo json_encode($response, JSON_UNESCAPED_UNICODE);

?>