<?php
error_reporting(E_ALL ^ E_NOTICE);

// Permite solicitudes desde cualquier origen (cuidado con esto en producción)
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

include_once '../conexion.php';

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$sql = $conn->prepare("CALL IM_Empleado(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,@IdEmpleado)");
$sql->bind_Param("issssssssssiiis", $datos[0], $datos[1], $datos[2], $datos[3], $datos[4], $datos[5], $datos[6], $datos[7],
    $datos[8], $datos[9], $datos[10], $datos[11], $datos[12], $datos[13], $datos[14]);

$sql->execute();

$respuesta = array();

if ($datos[14] == "NUEVO") {
    $result = mysqli_query($conn, "SELECT @IdEmpleado as nIdEmpleado");
    $mensaje = mysqli_fetch_assoc($result);

    if ($mensaje['nIdEmpleado'] > 0) {
        $resultado = array();
        $resultado['ESTADO'] = "1";
        $resultado['ID'] = $mensaje['nIdEmpleado'];
        $resultado['MENSAJE'] = "LA INFORMACION GUARDO CORRECTAMENTE";
    } else {
        $resultado = array();
        $resultado['ESTADO'] = "0";
        $resultado['ID'] = "0";
        $resultado['MENSAJE'] = "ERROR AL GUARDAR LA INFORMACIÓN: " . mysqli_error($conn);
    }
} else {
    $resultado = array();
    $resultado['ESTADO'] = "1";
    $resultado['MENSAJE'] = "LA INFORMACION ACTUALIZO CORRECTAMENTE";
}

mysqli_close($conn);

// Devolver la respuesta como un objeto JSON
header("HTTP/1.1 200 OK");
header("Content-Type: application/json; charset=UTF-8");
echo json_encode($resultado, JSON_PRETTY_PRINT);
?>
