<?php
error_reporting(E_ALL ^ E_NOTICE);

// Permite solicitudes desde cualquier origen (cuidado con esto en producción)
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

include_once '../conexion.php';

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$sql = $conn->prepare("CALL IM_Categoria(?,?,?,?,@IdCategoria)");
$sql->bind_Param("siis", $datos[0], $datos[1], $datos[2], $datos[3]);

$sql->execute();

$respuesta = array();

if ($datos[3] == "NUEVO") {
    $result = mysqli_query($conn, "SELECT @IdCategoria as nIdCategoria");
    $mensaje = mysqli_fetch_assoc($result);

    if ($mensaje['nIdCategoria'] > 0) {
        $resultado = array();
        $resultado['ESTADO'] = "1";
        $resultado['ID'] = $mensaje['nIdCategoria'];
        $resultado['MENSAJE'] = "LA INFORMACION GUARDO CORRECTAMENTE" .$mensaje['nIdCategoria'];;
    } else {
        $resultado = array();
        $resultado['ESTADO'] = "0";
        $resultado['ID'] = "0";
        $resultado['MENSAJE'] = "ERROR AL GUARDAR LA INFORMACIÓN: " . mysqli_error($conn);
    }
} else {
    $resultado = array();
    $resultado['ESTADO'] = "1";
    $resultado['MENSAJE'] = "LA INFORMACION ACTUALIZO CORRECTAMENTE";
}

mysqli_close($conn);

// Devolver la respuesta como un objeto JSON
header("HTTP/1.1 200 OK");
header("Content-Type: application/json; charset=UTF-8");
echo json_encode($resultado, JSON_PRETTY_PRINT);
?>
