<?php
error_reporting(E_ALL ^ E_NOTICE);

// Permite solicitudes desde cualquier origen (cuidado con esto en producción)
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

include_once '../conexion.php';

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$sql = $conn->prepare("CALL IM_Almacen(?,?,?,?,?,@IdAlmacen)");
$sql->bind_Param("siiis",$datos[0],$datos[1],$datos[2],$datos[3],$datos[4]);

$sql->execute();

$respuesta = array();

if ($datos[4] == "NUEVO") {
    $result = mysqli_query($conn, "SELECT @IdAlmacen as nIdAlmacen");
    $mensaje = mysqli_fetch_assoc($result);

    if ($mensaje['nIdAlmacen'] > 0) {
        $resultado = array();
        $resultado['ESTADO'] = "1";
        $resultado['ID'] = $mensaje['nIdAlmacen']; 
        $resultado['MENSAJE'] = "LA INFORMACION GUARDO CORRECTAMENTE";
    } else {
        $resultado = array();
        $resultado['ESTADO'] = "0";
        $resultado['ID'] = "0";
        $resultado['MENSAJE'] = "ERROR AL GUARDAR LA INFORMACION: " . mysqli_error($conn);
    }
} else {
    $resultado = array();
    $resultado['ESTADO'] = "1";
    $resultado['MENSAJE'] = "LA INFORMACION ACTUALIZO CORRECTAMENTE";
}

mysqli_close($conn);

// Devolver la respuesta como un objeto JSON
header("HTTP/1.1 200 OK");
header("Content-Type: application/json; charset=UTF-8");
echo json_encode($resultado, JSON_PRETTY_PRINT);
?>
