<?php
error_reporting(E_ALL ^ E_NOTICE);
// Permite la conexion desde cualquier origen
header("Access-Control-Allow-Origin: *");
// Permite la ejecucion de los metodos
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
// Se incluye el archivo que contiene la clase generica
include_once '../conexion.php';
$bodyRequest = file_get_contents("php://input");
// Decodifica el cuerpo de la solicitud y lo guarda en un array de PHP
$datos = json_decode($bodyRequest, true);

// echo "Receividos del cliente:";
// print_r($datos);

$sql = "SELECT V.fecha_emision, CONCAT(V.nserie,'-',V.ndocumento) ndocumento, V.razon_social, DV.descripcion_servicio AS nomproducto, DV.cantidad,
   DV.descrip_precio, DV.precioigv, if(V.formapago_id=1,DV.subtotaligv,0) AS contado, if(V.formapago_id=1,0,DV.subtotaligv) AS credito,
   Z.nombre AS zona, C.nombre AS categoria, M.nombre AS marca, DV.margen
   FROM ventas as V 
   INNER JOIN detventas as DV ON V.id = DV.venta_id 
   INNER JOIN zonas as Z ON V.zona_id = Z.id 
   INNER JOIN categorias as C ON DV.categoria_id = C.id 
   INNER JOIN marcas as M ON DV.marca_id = M.id 
   WHERE {$datos[0]} ORDER BY V.fecha_emision, V.docfiscal_id, CONCAT(V.nserie,'-',V.ndocumento)";

$rows = array();

// print_r($sql);

if ($result = mysqli_query($conn, $sql)) {
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $rows[] = $row;
        }
        mysqli_free_result($result);
    } else {
        //echo "No records matching your query were found.";
        print_json([]);
    }
} else {
    echo "ERROR: Could not able to execute the query."; // . mysqli_error($this->conn);
}
// Cerrar la conexión a la base de datos
mysqli_close($conn);

print_json($rows);
function print_json($data) {
    header("Content-type: application/json; charset=utf-8");
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    	
    switch (json_last_error()) {
        case JSON_ERROR_NONE:
            //  echo ' - No errors';
            break;
        case JSON_ERROR_DEPTH:
            echo ' - Maximum stack depth exceeded';
            break;
        case JSON_ERROR_STATE_MISMATCH:
            echo ' - Underflow or the modes mismatch';
            break;
        case JSON_ERROR_CTRL_CHAR:
            echo ' - Unexpected control character found';
            break;
        case JSON_ERROR_SYNTAX:
            echo ' - Syntax error, malformed JSON';
            break;
        case JSON_ERROR_UTF8:
            echo ' - Malformed UTF-8 characters, possibly incorrectly encoded';
            break;
        default:
            echo ' - Unknown error';
            break;
	}
}

?>