<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");

include_once '../conexion.php';

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$sql = $conn->prepare("CALL IM_Marca(?,?,?,?,@IdMarca)");
$sql->bind_Param("siis",$datos[0],$datos[1],$datos[2],$datos[3]);

$sql->execute();

if ($datos[3] == "NUEVO") {
    $result = mysqli_query($conn, "SELECT @IdMarca as nIdMarca");
    $mensaje = mysqli_fetch_assoc($result);
    $resultado = array(); // Crear un array para almacenar el resultado

    if ($mensaje['nIdMarca'] > 0) {
        $resultado['ESTADO'] = "1";
        $resultado['ID'] =$mensaje['nIdMarca']; 
        $resultado['MENSAJE'] = "LA INFORMACION GUARDO CORRECTAMENTE";
    } else {
        $resultado['ESTADO'] = "0";
        $resultado['ID'] = "0";
        $resultado['MENSAJE'] = "ERROR AL GUADAR LA INFORMACION: " . mysqli_error($conn);
    }

} else {
    $resultado = array();
    $resultado['ESTADO'] = "1";
    $resultado['MENSAJE'] = "LA INFORMACION ACTUALIZO CORRECTAMENTE";
}

mysqli_close($conn);

// Devolver la respuesta como un objeto JSON
header("HTTP/1.1 200 OK");
header("Content-Type: application/json; charset=UTF-8");
echo json_encode($resultado, JSON_PRETTY_PRINT);
?>
