<?php
include_once '../conexion.php';

// Obtener los datos combinados del cuerpo de la solicitud
$data = json_decode(file_get_contents("php://input"), true);

// Iniciar la transacción
mysqli_autocommit($conn, false);
// Variable para verificar el estado de la transacción
$transaccionExitosa = true;
$errorMensaje = "";

try {
     // Acceder a los valores individuales de los datos combinados
     $cEmpresa_Id = $data['Empresa_id'];
     $cDocFiscal_id = $data['DocFiscal_Id'];
     $cNSerie = $data['NSerie'];
     $cNDocumento = $data['NDocumento'];
     $cFechaEmision = $data['Fecha_Emision'];
     $cFechaTraslado = $data['Fecha_Traslado'];
     $cFechaVencimiento = $data['Fecha_Vcto'];
     $cNombre = mysqli_real_escape_string($conn, $data['Razon_Social']);
     $cDireccion = mysqli_real_escape_string($conn, $data['Direccion']);
     $cTipDocIdent = $data['Tipo_Documento'];
     $cDocIdentidad = $data['DocIdentidad'];
     $cNDias = $data['NDias'];
     $cMoneda = $data['Moneda'];
     $cTipoCambio = $data['Tipo_Cambio'];
     $cAfectoIgv = $data['Afecto_IGV'];
     $cP_Igv = $data['pIGV'];
     $cIgv = $data['IGV'];
     $cAfectDscto = $data['Descuento'];
     $cP_Dscto = $data['pDSCTO'];
     $cDescuento = $data['Descuento'];
     $cAfectoPercepcion = $data['Afecto_Percepcion'];
     $cP_Percepcion = $data['pPercepcion'];
     $cPercepcion = $data['Percepcion'];
     $cAfecto = $data['Valor_Compra'];
     $cInafecto = $data['Inafecto'];
     $cExonerado = $data['Exonerada'];
     $cTotal = $data['Total_Pagar'];
     $cGuiaRemision = $data['NGuiaRemision'];
     $cCancelado = $data['Cancelado'];
     $cIcbp = $data['ICBPER'];
     $cGratuitas = $data['Gratuitas'];
     $cAfectaKardex = $data['Afecta_Kardex'];
     $cAfectaCaja = $data['Afecta_Caja'];
     $cPeriodo = $data['Periodo'];
     $cMes = $data['Mes'];
     $cFormaPago_Id = $data['Forma_Pago'];
     $cCaja_Id = $data['Caja_Id'];
     $cProveedor_Id = $data['Proveedor_Id'];
     // $cEmpleado_id = $data['Empleado_Id'];
     $cSucursal_Id = $data['Sucursal_Id'];
     $cAlmacen_Id = $data['Almacen_Id'];
     $cObservacion = mysqli_real_escape_string($conn, $data['Observacion']);
     // $cAcuenta = $data['a_Cuenta'];
     $cServicio = $data['Servicio'];
     // $cZona_Id = $data['Zona_Id'];
     $iIdCmp = $data['IdCmp_M'];
     $cEstado = $data['Estado'];
          
    if ($cEstado == 'NUEVO') {

        // Ejemplo de inserción en la tabla productos
        $queryCabecera = "INSERT INTO compras(empresa_id, docfiscal_id, nserie, ndocumento, fecha_emision, fecha_traslado, fecha_vencimiento, 
        razon_social, direccion, tipo_docidentidad, documento_identidad, nro_dias, moneda, tipo_cambio, afecto_igv, 
        porcentaje_igv, igv, afecto_dscto, porcentaje_dscto, descuento, afecto_percepcion, porcentaje_percepcion, percepcion,
        afecto, inafecto, exonerado, total, guia_remision, cancelado, icbp, gratuitas, afecta_kardex, afecta_caja, periodo, mes, 
        formapago_id, caja_id, proveedor_id, sucursal_id, almacen_id, observacion, servicio)
        VALUES ('$cEmpresa_Id', '$cDocFiscal_id', '$cNSerie', '$cNDocumento', '$cFechaEmision', '$cFechaTraslado', '$cFechaVencimiento', 
        '$cNombre', '$cDireccion', '$cTipDocIdent', '$cDocIdentidad', '$cNDias', '$cMoneda', '$cTipoCambio', '$cAfectoIgv', '$cP_Igv', '$cIgv', 
        '$cAfectDscto', '$cP_Dscto', '$cDescuento', '$cAfectoPercepcion', '$cP_Percepcion', '$cPercepcion', '$cAfecto', '$cInafecto',
        '$cExonerado', '$cTotal', '$cGuiaRemision', '$cCancelado', '$cIcbp', '$cGratuitas', '$cAfectaKardex', '$cAfectaCaja', '$cPeriodo', '$cMes', 
        '$cFormaPago_Id', '$cCaja_Id', '$cProveedor_Id', '$cSucursal_Id', $cAlmacen_Id, '$cObservacion', '$cServicio')";

        $resultadoCabecera = mysqli_query($conn, $queryCabecera);
        if (!$resultadoCabecera) {
            throw new Exception(mysqli_error($conn));
        }

        // Obtener el ID del último registro insertado en la cabecera de compras
        $idCompra = mysqli_insert_id($conn);

        /*// ACTUALIZA REGISTRO DE SERIES
        $query = "SELECT numero FROM series_sucursal WHERE empresa_id = $cEmpresa_Id AND sucursal_id = $cSucursal_Id 
           AND nserie = '$cNSerie' FOR UPDATE";
        $result = mysqli_query($conn, $query);
        if (!$result) {
            throw new Exception(mysqli_error($conn));
        }

        $queryUPD = "UPDATE series_sucursal SET numero = numero + 1 WHERE empresa_id = $cEmpresa_Id AND sucursal_id = $cSucursal_Id 
          AND nserie = '$cNSerie'";
        $resultUPD = mysqli_query($conn, $queryUPD);  
        if (!$resultUPD) {
            throw new Exception(mysqli_error($conn));
        }*/

        // REGISTRO DE COMPRAS
        if ($cDocFiscal_id == 2 || $cDocFiscal_id == 4) {
            $queryReg_Compras = "INSERT INTO registro_compras(nserie, ndocumento, fecha_emision, fecha_vencimiento, tipo_docidentidad, documento_identidad,
                razon_social, afecto, exonerado, inafecto, igv, total, periodo, mes, moneda, tipo_cambio, docfiscal_id, compra_id, 
                empresa_id, sucursal_id)
                VALUES ('$cNSerie', '$cNDocumento', '$cFechaEmision', '$cFechaVencimiento', '$cTipDocIdent', '$cDocIdentidad', '$cNombre',
                '$cAfecto', '$cExonerado', '$cInafecto', '$cIgv', '$cTotal', '$cPeriodo', '$cMes', '$cMoneda', '$cTipoCambio', '$cDocFiscal_id',
                '$idCompra', '$cEmpresa_Id', '$cSucursal_Id')";
              
            $resultadoReg_Compras = mysqli_query($conn, $queryReg_Compras);
            if (!$resultadoReg_Compras) {
               throw new Exception(mysqli_error($conn));
            }
        };

        // CAJA
        if ($cAfectaCaja == 1) {
            if ($cFormaPago_Id == 1) {
                $queryCaja = "INSERT INTO detcaja(cuenta_id, tipo_movcaja, nrecibo, docfiscal_id, nserie, ndocumento, fecha_operacion,
                    fecha_emision, egreso, partida_id, nombre_partida, moneda, tipo_cambio, movimiento_id, operacion, 
                    observacion, offsystem, empresa_id, sucursal_id)
                    VALUES('$cCaja_Id', 'E', CONCAT('$cNSerie','-','$cNDocumento'), '$cDocFiscal_id', '$cNSerie', '$cNDocumento', '$cFechaEmision',
                    '$cFechaEmision', '$cTotal', '$cProveedor_Id', '$cNombre', '$cMoneda', '$cTipoCambio', '$idCompra', 'CMP', '$cObservacion', '1', '$cEmpresa_Id',
                    '$cSucursal_Id')";

                $resultadoCaja = mysqli_query($conn, $queryCaja);
                if (!$resultadoCaja) {
                    throw new Exception(mysqli_error($conn));
                }    
               
            };
        };

        // CREDITOS POR PAGAR
        if ($cFormaPago_Id == 2) {
           $queryCreditosxPag = "INSERT INTO creditos_pagar(nserie, ndocumento, nro_letra, nro_unico, fecha, fecha_vencimiento, documento_identidad, 
                razon_social, direccion, deuda_soles, deuda_dolar, moneda, tipo_cambio, proveedor_id, compra_id, sucursal_id, empresa_id)
                VALUES('$cNSerie', '$cNDocumento', '$cNSerie', '$cNDocumento', '$cFechaEmision', '$cFechaVencimiento', '$cDocIdentidad', '$cNombre', '$cDireccion',
                IF('$cMoneda'='01','$cTotal',0), IF('$cMoneda'='02','$cTotal',0), '$cMoneda', '$cTipoCambio', '$cProveedor_Id', '$idCompra', 
                '$cSucursal_Id','$cEmpresa_Id')"; 

            $resultadoCreditosxPag = mysqli_query($conn, $queryCreditosxPag);
            if (!$resultadoCreditosxPag) {
            throw new Exception(mysqli_error($conn));
            }    

        };

        // Ejemplo de inserción en la tabla detalle
        foreach ($data['detalle'] as $detalle_) {
            //$cCompra_Id = $idCompra;
            //$cNSerie = $detalle_['Nserie'];
            //$cNDocumento = $detalle_['Ndocumento'];
            //$cFechaEmision = $detalle_['Fecha_emision'];
            //$cFechaTraslado = $detalle_['Fecha_traslado'];
            $cOperacion = 'CMP';
            $cAlmacenId = $detalle_['almacen_id'];
            $cProducto_Id = $detalle_['producto_id'];
            $cBonificdProd = $detalle_['bonificacion'];
            $cCodProd = $detalle_['codigo_producto'];
            $cCantidad = $detalle_['cantidad'];
            $cRecogido = $detalle_['recogido'];
            $cCapacidad_Precio = $detalle_['capacidad_precio'];
            $cDescrip_Precio = $detalle_['descrip_precio'];
            $cPrecio_Bruto = $detalle_['precio_bruto'];
            $cDescuento = $detalle_['descuento'];
            $cPrecio = $detalle_['precio'];
            $cPrecioigv = $detalle_['precioigv'];
            $cIgv = $detalle_['igv'];
            $cPercepcion = $detalle_['percepcion'];
            $cAfecto = $detalle_['afecto'];
            $cInafecto = $detalle_['inafecto'];
            $cExonerado = $detalle_['exonerado'];
            $cSubtotal = $detalle_['subtotal'];
            $cSubtotaligv = $detalle_['subtotaligv'];
            // $cMargen = $detalle_['Margen'];
            $cCosto = $detalle_['costo'];
            $cPeso = $detalle_['peso'];
            $cPorcentaje_Igv = $detalle_['porcentaje_igv'];
            $cIcbp = $detalle_['icbp'];
            $cDescripcion_Servicio = $detalle_['descripcion_servicio'];
            $cVencimiento = $detalle_['vencimiento'];
            $cLote = $detalle_['lote'];
            $cAbrev_Universal = $detalle_['abrev_universal'];
            $cRazon_Social = $cNombre;
            $cObservacion = $cObservacion;
            $cIdDocFis = $cDocFiscal_id;
            $cCategoria_Id = $detalle_['categoria_id'];
            $cMarca_Id = $detalle_['marca_id'];
            $cFlete = $detalle_['flete'];
            $cEstiba = $detalle_['estiba'];
            $cModelo_Id = $detalle_['modelo_id'];
            $cPPMenor = $detalle_['pprecio_menor'];
            $cPrecio_MenorU = $detalle_['precmenor_und'];
            $cPrecio_MenorF = $detalle_['precmenor_fra'];
            $cPPMayor = $detalle_['pprecio_mayor'];
            $cPrecio_MayorU = $detalle_['precmayor_und'];
            $cPrecio_MayorF = $detalle_['precmayor_fra'];
            $cPPDist = $detalle_['pprecio_dist'];
            $cPrecio_DistU = $detalle_['precdist_und'];
            $cPrecio_DistF = $detalle_['precdist_fra'];
            //$cEmpresa_Id = $detalle_['empresa_id'];
            //$cSucursal_Id = $detalle_['sucursal_id'];

            $queryDetalle = "INSERT INTO detcompras (compra_id, nserie, ndocumento, fecha_emision, fecha_traslado, almacen_id, producto_id,
             bonificacion, codigo_producto, cantidad, recogido, capacidad_precio, descrip_precio, precio_bruto, descuento, precio, 
             precioigv, igv, percepcion, afecto, inafecto, exonerado, subtotal, subtotaligv, costo, peso, 
             porcentaje_igv, icbp, descripcion_servicio, vencimiento, lote, abrev_universal, docfiscal_id, categoria_id, marca_id,
             flete, estiba, modelo_id, pprecio_menor, precmenor_und, precmenor_fra, pprecio_mayor, precmayor_und, precmayor_fra, pprecio_dist, precdist_und, precdist_fra, empresa_id, sucursal_id) 
            VALUES ('$idCompra', '$cNSerie', '$cNDocumento', '$cFechaEmision', '$cFechaTraslado', '$cAlmacenId', '$cProducto_Id', 
            '$cBonificdProd', '$cCodProd', '$cCantidad', '$cRecogido', '$cCapacidad_Precio', '$cDescrip_Precio', '$cPrecio_Bruto', '$cDescuento', '$cPrecio', 
            '$cPrecioigv', '$cIgv', '$cPercepcion', '$cAfecto', '$cInafecto', '$cExonerado', '$cSubtotal', '$cSubtotaligv', '$cCosto', '$cPeso', 
            '$cPorcentaje_Igv', '$cIcbp', '$cDescripcion_Servicio', '$cVencimiento', '$cLote', '$cAbrev_Universal', '$cIdDocFis', '$cCategoria_Id', '$cMarca_Id',
            '$cFlete', '$cEstiba', '$cModelo_Id', '$cPPMenor', '$cPrecio_MenorU', '$cPrecio_MenorF', '$cPPMayor', '$cPrecio_MayorU', '$cPrecio_MayorF', '$cPPDist', '$cPrecio_DistU', '$cPrecio_DistF', '$cEmpresa_Id', '$cSucursal_Id')";
            
            $resultadoDetalle = mysqli_query($conn, $queryDetalle);
            if (!$resultadoDetalle) {
            throw new Exception(mysqli_error($conn));
            }

            //KARDEX
            if ($cAfectaKardex == 1) {
               $queryKardex = "INSERT INTO kardex(nserie, ndocumento, fecha_emision, fecha_traslado, operacion, producto_id, codigo_producto, entrada, costo, 
                salida, precio_venta, recogido, vencimiento, lote, transito, razon_social, observacion, unidad_medida, empresa_id, sucursal_id, 
                almacen_id, compra_id, venta_id, capacidad_Precio, docfiscal_id, categoria_id, marca_id, modelo_id)
               VALUES('$cNSerie', '$cNDocumento', '$cFechaEmision', '$cFechaTraslado', '$cOperacion', '$cProducto_Id', '$cCodProd', ('$cCantidad'*'$cCapacidad_Precio'),
               '$cCosto', 0, '$cPrecioigv', ('$cRecogido'*'$cCapacidad_Precio'), '$cVencimiento', '$cLote', 0, '$cNombre', '$cObservacion', 
                '$cDescrip_Precio', '$cEmpresa_Id', '$cSucursal_Id', '$cAlmacenId', '$idCompra', 0,  '$cCapacidad_Precio', '$cIdDocFis', '$cCategoria_Id', '$cMarca_Id',
                '$cModelo_Id')";

                $resultadoKardex = mysqli_query($conn, $queryKardex);

                if (!$resultadoKardex) {
                    throw new Exception(mysqli_error($conn));
                }
	         
	        }; 
        }

        /*// Ejemplo de inserción en la tabla cuotas
        foreach ($cuotas as $cuota) {
            $cVenta_Id = $idVenta; // Usar el mismo Id_Venta generado
            $cNroCuota = $cuota['Venta_id'];
            $cImporte = $cuota['Numero_cuota']; //
            $cFechaPago = $cuota['Fecha_pago'];
            $cCliente_Id = $cuota['Cliente_id'];
            $cEmpresa_Id = $cuota['Empresa_id'];
            $cSucursal_Id = $cuota['Sucursal_id']; // 

            $queryCuotas = "INSERT INTO cuotasclientes(venta_id, numero_cuota, importe, fecha_pago, cliente_id, empresa_id, sucursal_id)
            VALUES('$cVenta_Id', '$cNroCuota', '$cImporte', '$cFechaPago', '$cCliente_Id', '$cEmpresa_Id', '$cSucursal_Id')"; 
            $resultadoCuotas = mysqli_query($conn, $queryCuotas);   

            if (!$resultadoCuotas) {
                throw new Exception(mysqli_error($conn));
            }
        }*/

        // INSERT kardex_serieprod desde del tempkardex_serieprod
        if ($cAfectaKardex == 1) {
            $querySerieProducto = "INSERT INTO kardex_serieprod (producto_id, serie, cantidad, movimiento_id, operacion, nserie, ndocumento, empresa_id, sucursal_id, almacen_id) 
                SELECT producto_id, serie, cantidad, '$idCompra', operacion, nserie, ndocumento, empresa_id, sucursal_id, '$cAlmacen_Id' 
                FROM tempkardex_serieprod WHERE nserie = '$cNSerie' AND ndocumento = '$cNDocumento' AND empresa_id = $cEmpresa_Id AND sucursal_id = $cSucursal_Id";
            
            $resultadoSerieProducto = mysqli_query($conn, $querySerieProducto);        
            if (!$resultadoSerieProducto) {
               throw new Exception(mysqli_error($conn));
            }
        }
        
        //Elimina Temporal Kardex Serie para Evitar la Duplicidad
	    $queryDelTempKardexSerie = "DELETE FROM tempkardex_serieprod WHERE nserie = '$cNSerie' AND ndocumento = '$cNDocumento' AND empresa_id = $cEmpresa_Id AND sucursal_id = $cSucursal_Id";
        $resultadoDeTempKardexSerie = mysqli_query($conn, $queryDelTempKardexSerie);        
        if (!$resultadoDeTempKardexSerie) {
           throw new Exception(mysqli_error($conn));
        }
             
        /*foreach ($data['series'] as $serie) {
            $cCompra_Id = $idCompra;
            $cSerie = $serie['Serie'];
            $cOperacion = $serie['Operacion'];
            $cIdProducto = $serie['Producto_id'];

            $querySerieProducto = "UPDATE kardex_serieprod SET movimiento_id = '$cCompra_Id', operacion = '$cOperacion', IUD = ''
                    WHERE producto_id = '$cIdProducto' AND serie = '$cSerie'";
            $resultadoSerieProducto = mysqli_query($conn, $querySerieProducto);        

            if (!$resultadoSerieProducto) {
                throw new Exception(mysqli_error($conn));
            }
        }*/

    } elseif ($cEstado == 'MODIFICAR') { 
        $queryUpd_DetCmps = "UPDATE detcompras SET IUD = 'D' WHERE compra_id = $iIdCmp";
        $resultadoUpd_DetCmps = mysqli_query($conn, $queryUpd_DetCmps);        
        if (!$resultadoUpd_DetCmps) {
            throw new Exception(mysqli_error($conn));
        }
        
        $queryUpd_Kardex = "UPDATE kardex SET IUD = 'D' WHERE compra_id = $iIdCmp";
        $resultadoUpd_Kardex = mysqli_query($conn, $queryUpd_Kardex);        
        if (!$resultadoUpd_Kardex) {
            throw new Exception(mysqli_error($conn));
        }

        /*$queryUpd_Cuotas = "UPDATE cuotasproveedores SET IUD = 'D' WHERE compra_id = $iIdVta";
        $resultadoUpd_Cuotas = mysqli_query($conn, $queryUpd_Cuotas);        
        if (!$resultadoUpd_Cuotas) {
            throw new Exception(mysqli_error($conn));
        }*/

        $queryUpd_Kardex_Serie = "UPDATE kardex_serieprod SET IUD = 'D' WHERE movimiento_id = $iIdCmp AND operacion = 'CMP'";
        $resultadoUpd_Kardex_Serie = mysqli_query($conn, $queryUpd_Kardex_Serie);        
        if (!$resultadoUpd_Kardex_Serie) {
            throw new Exception(mysqli_error($conn));
        }

        $queryUpd_Compras = "UPDATE compras SET docfiscal_id = '$cDocFiscal_id', nserie = '$cNSerie', ndocumento = '$cNDocumento', 
             fecha_emision = '$cFechaEmision', fecha_traslado = '$cFechaTraslado', fecha_vencimiento = '$cFechaVencimiento', razon_social = '$cNombre',
             direccion = '$cDireccion', tipo_docidentidad = '$cTipDocIdent', documento_identidad = '$cDocIdentidad', nro_dias = '$cNDias', 
             moneda = '$cMoneda', tipo_cambio = '$cTipoCambio', afecto_igv = '$cAfectoIgv', porcentaje_igv = '$cP_Igv', igv = '$cIgv', 
             afecto_dscto = '$cAfectDscto', porcentaje_dscto = '$cP_Dscto', descuento = '$cDescuento', afecto_percepcion = '$cAfectoPercepcion', 
             porcentaje_percepcion = '$cP_Percepcion', percepcion = $cPercepcion, afecto = '$cAfecto', inafecto = '$cInafecto', exonerado = '$cExonerado',
             total = '$cTotal', guia_remision = '$cGuiaRemision', cancelado = '$cCancelado', icbp = '$cIcbp', gratuitas = '$cGratuitas', 
             afecta_kardex = '$cAfectaKardex', afecta_caja = '$cAfectaCaja', servicio = '$cServicio', periodo = '$cPeriodo', mes = '$cMes', formapago_id = '$cFormaPago_Id',
             caja_id = '$cCaja_Id', proveedor_id = '$cProveedor_Id', almacen_id = $cAlmacen_Id, observacion = '$cObservacion' WHERE id = $iIdCmp";
        
        $resultadoUpd_Compras = mysqli_query($conn, $queryUpd_Compras);        
        if (!$resultadoUpd_Compras) {
            throw new Exception(mysqli_error($conn));
        }
           
        // REGISTRO DE COMPRAS
        if ($cDocFiscal_id == 2 || $cDocFiscal_id == 4) {
           $queryUpd_RegCmps = "UPDATE registro_compras SET nserie = '$cNSerie', ndocumento = '$cNDocumento', fecha_emision = '$cFechaEmision', 
               fecha_vencimiento = '$cFechaVencimiento', tipo_docidentidad = '$cTipDocIdent', documento_identidad = '$cDocIdentidad',
               razon_social = '$cNombre', afecto = '$cAfecto', exonerado = '$cExonerado', inafecto = '$cInafecto', igv = '$cIgv', total = '$cTotal', 
               periodo = '$cPeriodo', mes = '$cMes', moneda = '$cMoneda', tipo_cambio = '$cTipoCambio', docfiscal_id = '$cDocFiscal_id'
               WHERE compra_id = $iIdCmp";
                
            $resultadoUpd_RegCmps = mysqli_query($conn, $queryUpd_RegCmps);        
            if (!$resultadoUpd_RegCmps) {
               throw new Exception(mysqli_error($conn));
            }
        };
           
        // CAJA
        if ($cAfectaCaja == 1) {
           if ($cFormaPago_Id == 2) {
             $queryDel_DetCaja = "DELETE FROM detcaja WHERE movimiento_id = $iIdCmp AND operacion = 'CMP'";
             
             $resultadoDel_DetCaja = mysqli_query($conn, $queryDel_DetCaja);        
             if (!$resultadoDel_DetCaja) {
                throw new Exception(mysqli_error($conn));
             }
           };  
             
           $queryCount = "SELECT COUNT(id) FROM detcaja WHERE movimiento_id = $iIdCmp AND operacion = 'CMP'";
           $result = mysqli_query($conn, $queryCount); // Suponiendo que has establecido una conexión a la base de datos ($conexion)
           if (!$result) {
              // Manejo de error si la consulta falla
              die("Error al ejecutar la consulta: " . mysqli_error($conn));
           }
             
           $row = mysqli_fetch_array($result);
           $count = $row[0];
           if ($count == 0) {
               $queryUpd_DetCaja = "INSERT INTO detcaja(cuenta_id, tipo_movcaja, nrecibo, docfiscal_id, nserie, ndocumento, fecha_operacion,
                 fecha_emision, egreso, partida_id, nombre_partida, moneda, tipo_cambio, movimiento_id, operacion, 
                 observacion, offsystem, empresa_id, sucursal_id)
               VALUES('$cCaja_Id', 'E', CONCAT('$cNSerie','-','$cNDocumento'), '$cDocFiscal_id', '$cNSerie', '$cNDocumento', '$cFechaEmision',
                 '$cFechaEmision', '$cTotal', '$cProveedor_Id', '$cNombre', '$cMoneda', '$cTipoCambio', '$iIdCmp', 'CMP', '$cObservacion', 1, '$cEmpresa_Id',
                 '$cSucursal_Id')";
           } else {
               $queryUpd_DetCaja = "UPDATE detcaja SET cuenta_id = '$cCaja_Id', tipo_movcaja = 'E', nrecibo = CONCAT('$cNSerie','-','$cNDocumento'),
                 fecha_operacion = '$cFechaEmision', docfiscal_id = '$cDocFiscal_id', nserie = '$cNSerie', ndocumento = '$cNDocumento', 
                 fecha_emision = '$cFechaEmision', egreso = '$cTotal', partida_id = '$cProveedor_Id', nombre_partida = '$cNombre', 
                 moneda = '$cMoneda', tipo_cambio = '$cTipoCambio', observacion = '$cObservacion' WHERE movimiento_id = $iIdCmp AND operacion = 'CMP'";
           }
           $resultUpdate = mysqli_query($conn, $queryUpd_DetCaja);
           if (!$resultUpdate) {
               // Manejo de error si la actualización falla
               die("Error al ejecutar la actualización: " . mysqli_error($conn));
           }
             
        };  
           
        // CREDITOS POR PAGAR
        if ($cFormaPago_Id == 2) {
            $queryCountCxP = "SELECT COUNT(id) FROM creditos_pagar WHERE compra_id = $iIdCmp";
            $result_CxP = mysqli_query($conn, $queryCountCxP); // Suponiendo que has establecido una conexión a la base de datos ($conexion)
            if (!$result_CxP) {
               // Manejo de error si la consulta falla
               die("Error al ejecutar la consulta: " . mysqli_error($conn));
            }
              
            $row_ = mysqli_fetch_array($result_CxP);
            $count_ = $row_[0];
            if ($count_ == 0) {
                $queryCreditosxPag = "INSERT INTO creditos_pagar(nserie, ndocumento, nro_letra, nro_unico, fecha, fecha_vencimiento, documento_identidad, 
                        razon_social, direccion, deuda_soles, deuda_dolar, moneda, tipo_cambio, proveedor_id, compra_id, sucursal_id, empresa_id)
                    VALUES('$cNSerie', '$cNDocumento', '$cNSerie', '$cNDocumento', '$cFechaEmision', '$cFechaVencimiento', '$cDocIdentidad', '$cNombre', '$cDireccion',
                        IF('$cMoneda'='01','$cTotal',0), IF('$cMoneda'='02','$cTotal',0), '$cMoneda', '$cTipoCambio', '$cProveedor_Id', '$iIdCmp', 
                        '$cSucursal_Id','$cEmpresa_Id')"; 
        
                 
            } else {
                $queryCreditosxPag = "UPDATE creditos_pagar SET nserie = '$cNSerie', ndocumento = '$cNDocumento', nro_letra = '$cNSerie', nro_unico = '$cNDocumento', 
                    fecha = '$cFechaEmision', fecha_vencimiento = '$cFechaVencimiento', razon_social = '$cNombre', 
                    deuda_soles = IF('$cMoneda'='01','$cTotal',0), deuda_dolar = IF('$cMoneda'='02','$cTotal',0), moneda = '$cMoneda', 
                    tipo_cambio = '$cTipoCambio', proveedor_id = '$cProveedor_Id' WHERE compra_id = $iIdCmp";
            }
            $resultadoCreditosxPag = mysqli_query($conn, $queryCreditosxPag);
            if (!$resultadoCreditosxPag) {
               throw new Exception(mysqli_error($conn));
            }   
         } else {
            $queryDelCxP = "DELETE FROM creditos_pagar WHERE compra_id = $iIdCmp";
            $resultadoDelCxP = mysqli_query($conn, $queryDelCxP);        
            if (!$resultadoDelCxP) {
                throw new Exception(mysqli_error($conn));
            }
        }

         // Ejemplo de inserción en la tabla detalle
        foreach ($data['detalle'] as $detalle_) {
            //$cVenta_Id = $idVenta;
            //$cNSerie = $detalle_['Nserie'];
            //$cNDocumento = $detalle_['Ndocumento'];
            //$cFechaEmision = $detalle_['Fecha_emision'];
            //$cFechaTraslado = $detalle_['Fecha_traslado'];
            $cOperacion = 'CMP';
            $cAlmacenId = $detalle_['almacen_id'];
            $cProducto_Id = $detalle_['producto_id'];
            $cBonificdProd = $detalle_['bonificacion'];
            $cCodProd = $detalle_['codigo_producto'];
            $cCantidad = $detalle_['cantidad'];
            $cRecogido = $detalle_['recogido'];
            $cCapacidad_Precio = $detalle_['capacidad_precio'];
            $cDescrip_Precio = $detalle_['descrip_precio'];
            $cPrecio_Bruto = $detalle_['precio_bruto'];
            $cDescuento = $detalle_['descuento'];
            $cPrecio = $detalle_['precio'];
            $cPrecioigv = $detalle_['precioigv'];
            $cIgv = $detalle_['igv'];
            $cPercepcion = $detalle_['percepcion'];
            $cAfecto = $detalle_['afecto'];
            $cInafecto = $detalle_['inafecto'];
            $cExonerado = $detalle_['exonerado'];
            $cSubtotal = $detalle_['subtotal'];
            $cSubtotaligv = $detalle_['subtotaligv'];
            // $cMargen = $detalle_['Margen'];
            $cCosto = $detalle_['costo'];
            $cPeso = $detalle_['peso'];
            $cPorcentaje_Igv = $detalle_['porcentaje_igv'];
            $cIcbp = $detalle_['icbp'];
            $cDescripcion_Servicio = $detalle_['descripcion_servicio'];
            $cVencimiento = $detalle_['vencimiento'];
            $cLote = $detalle_['lote'];
            $cAbrev_Universal = $detalle_['abrev_universal'];
            $cRazon_Social = $cNombre;
            $cObservacion = $cObservacion;
            $cIdDocFis = $cDocFiscal_id;
            $cCategoria_Id = $detalle_['categoria_id'];
            $cMarca_Id = $detalle_['marca_id'];
            $cFlete = $detalle_['flete'];
            $cEstiba = $detalle_['estiba'];
            $cModelo_Id = $detalle_['modelo_id'];
            $cPPMenor = $detalle_['pprecio_menor'];
            $cPrecio_MenorU = $detalle_['precmenor_und'];
            $cPrecio_MenorF = $detalle_['precmenor_fra'];
            $cPPMayor = $detalle_['pprecio_mayor'];
            $cPrecio_MayorU = $detalle_['precmayor_und'];
            $cPrecio_MayorF = $detalle_['precmayor_fra'];
            $cPPDist = $detalle_['pprecio_dist'];
            $cPrecio_DistU = $detalle_['precdist_und'];
            $cPrecio_DistF = $detalle_['precdist_fra'];
            //$cEmpresa_Id = $detalle_['Empresa_id'];
            //$cSucursal_Id = $detalle_['Sucursal_id'];

            $queryDetalle = "INSERT INTO detcompras (compra_id, nserie, ndocumento, fecha_emision, fecha_traslado, almacen_id, producto_id,
             bonificacion, codigo_producto, cantidad, recogido, capacidad_precio, descrip_precio, precio_bruto, descuento, precio, 
             precioigv, igv, percepcion, afecto, inafecto, exonerado, subtotal, subtotaligv, costo, peso, 
             porcentaje_igv, icbp, descripcion_servicio, vencimiento, lote, abrev_universal, docfiscal_id, categoria_id, marca_id,
             flete, estiba, modelo_id, pprecio_menor, precmenor_und, precmenor_fra, pprecio_mayor, precmayor_und, precmayor_fra, pprecio_dist, precdist_und, precdist_fra, empresa_id, sucursal_id) 
            VALUES ('$iIdCmp', '$cNSerie', '$cNDocumento', '$cFechaEmision', '$cFechaTraslado', '$cAlmacenId', '$cProducto_Id', 
            '$cBonificdProd', '$cCodProd', '$cCantidad', '$cRecogido', '$cCapacidad_Precio', '$cDescrip_Precio', '$cPrecio_Bruto', '$cDescuento', '$cPrecio', 
            '$cPrecioigv', '$cIgv', '$cPercepcion', '$cAfecto', '$cInafecto', '$cExonerado', '$cSubtotal', '$cSubtotaligv', '$cCosto', '$cPeso', 
            '$cPorcentaje_Igv', '$cIcbp', '$cDescripcion_Servicio', '$cVencimiento', '$cLote', '$cAbrev_Universal', '$cIdDocFis', '$cCategoria_Id', '$cMarca_Id',
            '$cFlete', '$cEstiba', '$cModelo_Id', '$cPPMenor', '$cPrecio_MenorU', '$cPrecio_MenorF', '$cPPMayor', '$cPrecio_MayorU', '$cPrecio_MayorF', '$cPPDist', '$cPrecio_DistU', '$cPrecio_DistF', '$cEmpresa_Id', '$cSucursal_Id')";
            $resultadoDetalle = mysqli_query($conn, $queryDetalle);

            if (!$resultadoDetalle) {
            throw new Exception(mysqli_error($conn));
            }

            //KARDEX
            if ($cAfectaKardex == 1) {
               $queryKardex = "INSERT INTO kardex(nserie, ndocumento, fecha_emision, fecha_traslado, operacion, producto_id, codigo_producto, entrada, costo, 
                salida, precio_venta, recogido, vencimiento, lote, transito, razon_social, observacion, unidad_medida, empresa_id, sucursal_id, 
                almacen_id, compra_id, venta_id, capacidad_Precio, docfiscal_id, categoria_id, marca_id, modelo_id)
               VALUES('$cNSerie', '$cNDocumento', '$cFechaEmision', '$cFechaTraslado', '$cOperacion', '$cProducto_Id', '$cCodProd', ('$cCantidad'*'$cCapacidad_Precio'),
                '$cCosto', 0, '$cPrecioigv', ('$cRecogido'*'$cCapacidad_Precio'), '$cVencimiento', '$cLote', 0, '$cNombre', '$cObservacion', 
                '$cDescrip_Precio', '$cEmpresa_Id', '$cSucursal_Id', '$cAlmacenId', '$iIdCmp', 0, '$cCapacidad_Precio', '$cIdDocFis', '$cCategoria_Id', '$cMarca_Id',
                '$cModelo_Id')";

                $resultadoKardex = mysqli_query($conn, $queryKardex);

                if (!$resultadoKardex) {
                     throw new Exception(mysqli_error($conn));
                }
	         
	        }; 
        }

        /*// Ejemplo de inserción en la tabla cuotas
        foreach ($cuotas as $cuota) {
            $cCompra_Id = $idCompra; // Usar el mismo Id_Venta generado
            $cNroCuota = $cuota['Venta_id'];
            $cImporte = $cuota['Numero_cuota']; //
            $cFechaPago = $cuota['Fecha_pago'];
            $cCliente_Id = $cuota['Cliente_id'];
            $cEmpresa_Id = $cuota['Empresa_id'];
            $cSucursal_Id = $cuota['Sucursal_id']; // 

            $queryCuotas = "INSERT INTO cuotasclientes(venta_id, numero_cuota, importe, fecha_pago, cliente_id, empresa_id, sucursal_id)
            VALUES('$cVenta_Id', '$cNroCuota', '$cImporte', '$cFechaPago', '$cCliente_Id', '$cEmpresa_Id', '$cSucursal_Id')"; 
            $resultadoCuotas = mysqli_query($conn, $queryCuotas);   

            if (!$resultadoCuotas) {
                throw new Exception(mysqli_error($conn));
            }
        }*/
        
        // INSERT kardex_serieprod desde del tempkardex_serieprod
        if ($cAfectaKardex == 1) {
            $querySerieProducto = "INSERT INTO kardex_serieprod (producto_id, serie, cantidad, movimiento_id, operacion, nserie, ndocumento, empresa_id, sucursal_id, almacen_id) 
                SELECT producto_id, serie, cantidad, '$iIdCmp', operacion, nserie, ndocumento, empresa_id, sucursal_id, '$cAlmacen_Id' FROM tempkardex_serieprod 
                WHERE movimiento_id = $iIdCmp AND operacion = 'CMP'";
            
            $resultadoSerieProducto = mysqli_query($conn, $querySerieProducto);        
            if (!$resultadoSerieProducto) {
               throw new Exception(mysqli_error($conn));
            }
        }

        // Ejemplo de inserción en la tabla series
        /*foreach ($data['series'] as $serie) {
            $cCompra_Id = $iIdCmp;
            $cSerie = $serie['Serie'];
            $cOperacion = $serie['Operacion'];
            $cIdProducto = $serie['Producto_id'];

            $querySerieProducto = "UPDATE kardex_serieprod SET movimiento_id = '$cCompra_Id', operacion = '$cOperacion', IUD = ''
                    WHERE producto_id = '$cIdProducto' AND serie = '$cSerie'";
            $resultadoSerieProducto = mysqli_query($conn, $querySerieProducto);        

            if (!$resultadoSerieProducto) {
                throw new Exception(mysqli_error($conn));
            }
        }*/

        //Elimina Detalle de Compra para Evitar la Duplicidad
        $queryDelCmps = "DELETE FROM detcompras WHERE compra_id = $iIdCmp AND IUD = 'D'";
        $resultadoDelCmps = mysqli_query($conn, $queryDelCmps);        
        if (!$resultadoDelCmps) {
           throw new Exception(mysqli_error($conn));
        }

        //Elimina Kardex para Evitar la Duplicidad
	    $queryDelKardex = "DELETE FROM kardex WHERE compra_id = $iIdCmp AND IUD = 'D'";
        $resultadoDelKardex = mysqli_query($conn, $queryDelKardex);        
        if (!$resultadoDelKardex) {
           throw new Exception(mysqli_error($conn));
        }

        //Elimina Cuotas del Proveedor para Evitar la Duplicidad
	    /*$queryDelCuotas = "DELETE FROM cuotasproveedores WHERE compra_id = $iIdCmp AND IUD = 'D'";
        $resultadoDelCuotas = mysqli_query($conn, $queryDelCuotas);        
        if (!$resultadoDelCuotas) {
           throw new Exception(mysqli_error($conn));
        }*/

        //Elimina Kardex Serie para Evitar la Duplicidad
	    $queryDelKardexSerie = "DELETE FROM kardex_serieprod WHERE movimiento_id = $iIdCmp AND operacion = 'CMP' AND IUD = 'D'";
        $resultadoDelKardexSerie = mysqli_query($conn, $queryDelKardexSerie);        
        if (!$resultadoDelKardexSerie) {
           throw new Exception(mysqli_error($conn));
        }
        
        //Elimina Temporal Kardex Serie para Evitar la Duplicidad
	    $queryDelTempKardexSerie = "DELETE FROM tempkardex_serieprod WHERE movimiento_id = $iIdCmp AND operacion = 'CMP'";
        $resultadoDeTempKardexSerie = mysqli_query($conn, $queryDelTempKardexSerie);        
        if (!$resultadoDeTempKardexSerie) {
           throw new Exception(mysqli_error($conn));
        }

    }

    // Confirmar la transacción
    mysqli_commit($conn);
    
} catch (Exception $e) {
    // Revertir la transacción en caso de error
    mysqli_rollback($conn);
    $transaccionExitosa = false;
    $errorMensaje = $e->getMessage();
}

// Cerrar la conexión a la base de datos
mysqli_close($conn);

// Enviar una respuesta al cliente
if ($transaccionExitosa) {
    $response = array("ESTADO" => "00", "MENSAJE" => "Los datos se han guardado correctamente");
} else {
    $response = array("ESTADO" => "11", "MENSAJE" => "Error al guardar la información: " . $errorMensaje);
}
echo json_encode($response);

?>